﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="TranslationAudit.aspx.cs" Inherits="Smartling.Connector.sitecore_modules.Shell.Smartling.Connector.TranslationAudit" %>

<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>Translation Audit</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css" integrity="sha384-BVYiiSIFeK1dGmJRAkycuHAHRg32OmUcww7on3RYdg4Va+PmSTsz/K68vbdEjh4u" crossorigin="anonymous">
    <link href="/sitecore modules/shell/Smartling.Connector/css/bootstrap-multiselect.css" rel="stylesheet" />
    <link href="/sitecore modules/shell/Smartling.Connector/css/jquery.dataTables.min.css" rel="stylesheet" />
    <link href="/sitecore modules/shell/Smartling.Connector/css/dataTables.checkboxes.css" rel="stylesheet" />
    <link href="/sitecore modules/shell/Smartling.Connector/css/smartling.css" rel="stylesheet" />
</head>
<body>
    <div>
        <div class="form-horizontal header">
            <div class="searchButton">
                <button type="button" id="search" class="btn btn-success">Search</button>&nbsp;
            </div>
            <div class="filterWrapper">
                <div class="contentFilter">
                    <input class="form-control" id="query" placeholder="Search" type="text">
                </div>
                <div class="contentFilter">
                    <input class="form-control" id="job" placeholder="Smartling Job" type="text">
                </div>
                <div class="contentFilter">
                    <input class="form-control" id="item" placeholder="Sitecore Item" type="text">
                </div>
                <div class="contentFilter">
                    <input class="form-control" id="submitter" placeholder="Submitter" type="text">
                </div>
                <div class="contentFilter">
                    <select id="profile" name="profile" class="form-control">
                        <asp:Literal ID="Profiles" runat="server"></asp:Literal>
                    </select>&nbsp;
                </div>
                <div class="contentFilter">
                    <select id="language" name="language[]" class="form-control" multiple="multiple">
                        <asp:Literal ID="LanguageOptions" runat="server"></asp:Literal>
                    </select>&nbsp;
                </div>
                <div class="contentFilter">
                    <select id="eventType" name="eventType[]" class="form-control" multiple="multiple">
                        <asp:Literal ID="EventTypes" runat="server"></asp:Literal>
                    </select>&nbsp;
                </div>
            </div>
        </div>
        <table id="items" class="table table-hover" style="width: 100%;">
            <thead>
                <tr>
                    <th>Path</th>
                    <th>Source</th>
                    <th>Target</th>
                    <th>Source&nbsp;Ver.</th>
                    <th>Target&nbsp;Ver.</th>
                    <th>Job&nbsp;Name</th>
                    <th>Submitter</th>
                    <th>Event</th>
                    <th>Time</th>
                    <th>Description</th>
                </tr>
            </thead>
            <tbody>
            </tbody>
        </table>
    </div>

    <script type="text/javascript" src="/sitecore modules/shell/Smartling.Connector/js/jquery.js"></script>
    <script type="text/javascript" src="/sitecore modules/shell/Smartling.Connector/js/bootstrap.min.js"></script>
    <script type="text/javascript" src="/sitecore modules/shell/Smartling.Connector/js/jquery.dataTables.min.js"></script>
    <script type="text/javascript" src="/sitecore modules/shell/Smartling.Connector/js/dataTables.checkboxes.js"></script>
    <script type="text/javascript" src="/sitecore modules/shell/Smartling.Connector/js/bootstrap-multiselect.js"></script>
    <script type="text/javascript">
        $(document).ready(function () {           
            var table = $('#items').DataTable({
                "ajax": {
                    "url": '/sitecore%20modules/shell/Smartling.Connector/AuditApi.ashx'
                    ,
                    "data": function (d) {
                        return {
                            "query": $('#query').val(),
                            "profile": $('#profile').val(),
                            "job": $('#job').val(),
                            "item": $('#item').val(),
                            "submitter": $('#submitter').val(),
                            "language": $('#language').val(),
                            "eventType": $('#eventType').val(),
                            "draw": d.draw,
                            "start": d.start,
                            "length": d.length
                        };
                    }
                },
                "dom": "<'row'<'col-sm-6'><'col-sm-6'f>>" +
                       "<'row'<'col-sm-12'tr>>" +
                       "<'row'<'col-sm-5'li><'col-sm-7'p>>",
                "paging": true,
                "processing": true,
                "serverSide": true,
                "searching": false,
                "ordering": false,
                'columnDefs': [
                    { className: "dt-right", "targets": [3, 4] },
                    { orderable: false, "targets": "_all" },
                    { "width": "80px", "targets": 1 },
                    { "width": "80px", "targets": 2 },
                    { "width": "50px", "targets": 3 },
                    { "width": "50px", "targets": 4 },
                    { "width": "90px", "targets": 6 },
                    { "width": "80px", "targets": 7 },
                    { "width": "80px", "targets": 8 }
            ],
                'select': {
                    'style': 'multi'
                }
            });

            $('#profile').multiselect({
                nonSelectedText: 'Language',
                buttonWidth: '100px',
                onChange: function () {
                    table.ajax.reload();
                }
            });

            $('#language').multiselect({
                includeSelectAllOption: true,
                nonSelectedText: 'Language',
                buttonWidth: '100px',
                onChange: function () {
                    table.ajax.reload();
                }
            });

            $('#eventType').multiselect({
                includeSelectAllOption: true,
                buttonWidth: '100px',
                nonSelectedText: 'Event',
                onChange: function () {
                    table.ajax.reload();
                }
            });

            $("#search").click(function () {
                table.ajax.reload();
            });

            $('input').keypress(function (e) {
                if (e.which == 13) {
                    table.ajax.reload();
                    return false;
                }
            });
        });
    </script>
</body>
</html>